IF  EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[hips].[MonitoringIhiConnectionFailure]') AND type in (N'P', N'PC'))
DROP PROCEDURE [hips].[MonitoringIhiConnectionFailure]
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
-- =============================================
-- Author:        Philip Stalley-Gordon 
-- Create date:   24 May 2013
-- Description:   Gets IHI % of connection failure in the timeframe specified
-- =============================================
Create PROCEDURE [hips].[MonitoringIhiConnectionFailure] 
(
	@Minutes Integer 
)
AS
BEGIN
	
	DECLARE @ihiRequests INT, @ihiConnectionFailures INT

	SELECT @ihiRequests = COUNT(*) 		
		FROM  hips.IhiLookupAudit s WITH (NOLOCK)
		WHERE DATEDIFF(minute, DateCreated, SYSDATETIME())<=@Minutes

	SELECT @ihiConnectionFailures = COUNT(*)
		FROM hips.[MonitoringSyslog]
		WHERE MonitorTabId = 3
		AND DATEDIFF(minute, DateCreated, SYSDATETIME())<=@Minutes

	IF (@ihiRequests = 0)
	BEGIN
		SELECT 0.0
	END
	ELSE
	BEGIN
		SELECT  CAST(ROUND(((@ihiConnectionFailures)*1.0/@ihiRequests*1.0)*100,1,1) AS DECIMAL(6,1)) AS PercentageSuccess
	END

END
GO

